% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoPipeline-functions.R
\name{handlingProcessingSteps}
\alias{handlingProcessingSteps}
\alias{addProcessingStep}
\alias{removeProcessingStep}
\alias{getNbProcessingSteps}
\alias{getProcessingStep}
\alias{getProcessingStepNames}
\alias{cleanProcessingSteps}
\alias{showProcessingSteps}
\title{handling processing steps in CytoPipeline objects}
\usage{
addProcessingStep(
  x,
  whichQueue = c("scale transform", "pre-processing"),
  newPS
)

removeProcessingStep(
  x,
  whichQueue = c("scale transform", "pre-processing"),
  index
)

getNbProcessingSteps(x, whichQueue = c("scale transform", "pre-processing"))

getProcessingStep(
  x,
  whichQueue = c("scale transform", "pre-processing"),
  index
)

getProcessingStepNames(x, whichQueue = c("scale transform", "pre-processing"))

cleanProcessingSteps(
  x,
  whichQueue = c("both", "scale transform", "pre-processing")
)

showProcessingSteps(x, whichQueue = c("scale transform", "pre-processing"))
}
\arguments{
\item{x}{a CytoPipeline object}

\item{whichQueue}{selects the processing queue for which we manage the
processing steps}

\item{newPS}{the new processing step to be added (CytoProcessingStep object)}

\item{index}{index of the processing step to remove}
}
\value{
\itemize{
\item for \code{addProcessingStep}: the updated CytoPipeline object
}

\itemize{
\item for \code{removeProcessingStep}: the updated CytoPipeline object
}

\itemize{
\item for \code{getNbProcessingSteps}: the number of processing steps present
in the target queue
}

\itemize{
\item for \code{getProcessingStep}: the obtained CytoProcessingStep object
}

\itemize{
\item for \code{getProcessingStepNames}: the vector of step names
}

\itemize{
\item for \code{cleanProcessingSteps}: the updated CytoPipeline object
}

\itemize{
\item for \code{showProcessingSteps}: nothing (only console display side
effect is required)
}
}
\description{
functions to manipulate processing steps in processing queues
of CytoPipeline objects
}
\section{Functions}{
\itemize{
\item \code{addProcessingStep()}: adds a processing step in one of the
processing queues (at the end), returns the modified CytoPipeline object

\item \code{removeProcessingStep()}: removes a processing step from one of
the processing queues, returns the modified CytoPipeline object

\item \code{getNbProcessingSteps()}: gets the number of processing
steps in a processing queue

\item \code{getProcessingStep()}: gets a processing step at a
specific index of a processing queue

\item \code{getProcessingStepNames()}: gets a character vector of all
processing step names of a specific processing queue

\item \code{cleanProcessingSteps()}: deletes all processing steps in one
or both processing queues, returns the modified CytoPipeline object

\item \code{showProcessingSteps()}: shows all processing steps in a
processing queue

}}
\examples{

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- file.path(rawDataDir, list.files(rawDataDir,
                                             pattern = "Donor"))
transListPath <- 
    file.path(system.file("extdata", package = "CytoPipeline"), 
              "OMIP021_TransList.rds")

# main parameters : sample files and experiment name
pipelineParams <- list()
pipelineParams$experimentName <- experimentName
pipelineParams$sampleFiles <- sampleFiles

# create CytoPipeline object (no step defined yet)
pipL <- CytoPipeline(pipelineParams)

# add a processing step in scale tranformation queue
pipL <- addProcessingStep(pipL,
                          whichQueue = "scale transform",
                          CytoProcessingStep(
                              name = "scale_transform_read",
                              FUN = "readRDS",
                              ARGS = list(file = transListPath)
                          ))

getNbProcessingSteps(pipL, "scale transform") # returns 1

# add another processing step in scale transformation queue
pipL <- addProcessingStep(pipL,
                          whichQueue = "scale transform",
                          CytoProcessingStep(
                              name = "scale_transform_sum",
                              FUN = "sum",
                              ARGS = list()
                          )
)

getNbProcessingSteps(pipL, "scale transform") # returns 2

getProcessingStepNames(pipL, whichQueue = "scale transform")

# removes second processing step in scale transformation queue
pipL <- removeProcessingStep(pipL,
                             whichQueue = "scale transform",
                             index = 2)

# get processing step object
pS <- getProcessingStep(pipL, whichQueue = "scale transform", index = 1)
getCPSName(pS) #"scale_transform_read"

# add a processing step in pre-processing queue
pipL <- addProcessingStep(pipL,
                          whichQueue = "pre-processing",
                          CytoProcessingStep(
                              name = "pre-processing_sum",
                              FUN = "sum",
                              ARGS = list()
                          ))
getNbProcessingSteps(pipL, "scale transform") # returns 1
getNbProcessingSteps(pipL, "pre-processing") # returns also 1

showProcessingSteps(pipL, whichQueue = "scale transform")
showProcessingSteps(pipL, whichQueue = "pre-processing")

# cleans both processing queues
pipL <- cleanProcessingSteps(pipL)
pipL
}
