% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{featureNames}
\alias{featureNames}
\alias{featureNames,DNEA-method}
\title{Retrieve the feature names from the metadata slot.}
\usage{
featureNames(x, original = FALSE)

\S4method{featureNames}{DNEA}(x, original = FALSE)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}

\item{original}{"TRUE" returns the original feature names
and "FALSE" returns the feature names that have been
modified to avoid errors as a result of special characters
using \code{\link[janitor:make_clean_names]{make_clean_names}}.}
}
\value{
A character vector of feature names.
}
\description{
This function accesses the feature names stored in the
metadata slot of the \code{\link{DNEA}} object.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

featureNames(dnw, original=TRUE)
}
\seealso{
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
