% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{DOTSeqDataSets-class}
\alias{DOTSeqDataSets-class}
\alias{show,DOTSeqDataSets-method}
\title{DOTSeqDataSets-class}
\usage{
\S4method{show}{DOTSeqDataSets}(object)
}
\arguments{
\item{object}{A \code{\link{DOTSeqDataSets-class}} object.}
}
\value{
A \code{\link{DOTSeqDataSets-class}} S4 object containing DOU and DTE results.
}
\description{
A wrapper class to store both DOU and DTE results from \pkg{DOTSeq}
analysis.

Displays a summary of the DOTSeqDataSets object.
}
\section{Slots}{

\describe{
\item{\code{DOU}}{A \code{\link{DOUData-class}} object.}

\item{\code{DTE}}{A \code{\link{DTEData-class}} object.}
}}

\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
