% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{assign_strategy_levels}
\alias{assign_strategy_levels}
\title{Assign strategy levels for RNA-seq and Ribo-seq}
\usage{
assign_strategy_levels(input_df, strategy_col = "strategy")
}
\arguments{
\item{input_df}{A data frame containing a column that encodes
strategy labels.}

\item{strategy_col}{A string specifying the name of the column in
\code{input_df} that contains strategy labels. Default is "strategy".}
}
\value{
A named list with two elements:
\describe{
\item{ribo_level}{The detected level corresponding to Ribo-seq.}
\item{rna_level}{The detected level corresponding to RNA-seq.}
}
}
\description{
This function identifies and assigns the reference and target levels
for RNA-seq and Ribo-seq strategies from a given input data frame.
It uses a flexible regular expression to match common representations
of RNA-seq (e.g., "rna", "RNA", "RNA-seq", or "0") and assigns the
remaining unique value(s) as Ribo-seq.
}
\examples{
\dontrun{
df <- data.frame(strategy = c("RNA", "Ribo"))
assign_strategy_levels(df)
}

}
\keyword{internal}
