% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{calculateTE}
\alias{calculateTE}
\title{Calculate Translational Efficiency and Shifts in ORF Usage}
\usage{
calculateTE(
  counts,
  rna_suffix = ".rna",
  ribo_suffix = ".ribo",
  sample_delim = ".",
  pseudocount = 1e-06
)
}
\arguments{
\item{counts}{A numeric matrix or data frame of normalized counts, where
rows correspond to ORFs and columns correspond to samples. RNA-seq
and Ribo-seq reads are distinguished by suffixes.}

\item{rna_suffix}{Character string indicating the suffix of RNA-seq
samples in the column names. Default is \code{".rna"}.}

\item{ribo_suffix}{Character string indicating the suffix of Ribo-seq
samples in the column names. Default is \code{".ribo"}.}

\item{sample_delim}{Character. Delimiter used in sample names.
Default is \code{"."}.}

\item{pseudocount}{Numeric value added to counts to avoid division by
zero. Default is \code{1e-6}.}
}
\value{
A matrix of translational efficiency (TE), calculated as the ratio of
Ribo-seq to RNA-seq counts for each matched sample (by prefix).
}
\description{
This function computes translational efficiency (TE) and ORF usage for
a set of normalized RNA-seq and Ribo-seq counts. TE is calculated as
the ratio of Ribo-seq counts to RNA-seq counts. ORF usage is
aproximnated as the fraction of total signal (Ribo-proportion and
RNA-proportion) that comes from Ribo-proportion, per ORF and condition.
}
\keyword{internal}
