% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit_glmm}
\alias{fit_glmm}
\title{Fit a Beta-Binomial GLMM with Multiple Optimizers}
\usage{
fit_glmm(
  formula,
  dispformula,
  data,
  family = betabinomial(),
  parallel = list(n = 4L, autopar = TRUE),
  optimizers = c("nlminb", "bobyqa", "optim"),
  max_iter = 1000
)
}
\arguments{
\item{formula}{A formula object specifying the fixed effects structure of
the model.}

\item{dispformula}{A formula object specifying the dispersion model
(e.g., \code{~strategy}).}

\item{data}{A data frame containing the model data, including counts and
covariates.}

\item{optimizers}{A character vector of optimizer names to try sequentially.
Supported values include \code{"nlminb"}, \code{"bobyqa"}, and
\code{"optim"}. Default is \code{c("nlminb", "bobyqa", "optim")}.}

\item{max_iter}{An integer specifying the maximum number of iterations for
the optimizer. Default is \code{1000}.}
}
\value{
A fitted \code{\link[glmmTMB]{glmmTMB}} model object if convergence is successful.
If all optimizers fail, the last attempted model (with convergence
failure) is returned.
}
\description{
This internal function fits a beta-binomial GLM or GLMM using
\code{\link[glmmTMB]{glmmTMB}}, with support for multiple optimizers to
improve convergence. It is used as a backend for fitting models to
ORF-level count data in DOTSeq.
}
\details{
The function attempts to fit the model using each optimizer in the specified
order. If a model converges successfully (i.e.,
\code{model$fit$convergence == 0} and \code{model$sdr$pdHess == TRUE}),
it is returned immediately. Otherwise, the function continues trying the
next optimizer.
}
\references{
Brooks, M. E., Kristensen, K., van Benthem, K. J., Magnusson, A., Berg, C. W.,
Nielsen, A., Skaug, H. J., Mächler, M. and Bolker, B. M. (2017).
glmmTMB balances speed and flexibility among packages for zero-inflated
generalized linear mixed modeling. The R Journal, 378–400.
DOI: 10.32614/RJ-2017-066
}
\keyword{internal}
