% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{getDTE}
\alias{getDTE}
\alias{getDTE,DOTSeqDataSets-method}
\alias{getDTE<-}
\alias{getDTE<-,DOTSeqDataSets-method}
\title{Accessor and replacement methods for DTE slot}
\usage{
getDTE(object)

\S4method{getDTE}{DOTSeqDataSets}(object)

getDTE(object) <- value

\S4method{getDTE}{DOTSeqDataSets}(object) <- value
}
\arguments{
\item{object}{A \code{\link{DOTSeqDataSets-class}} object.}

\item{value}{A replacement object (e.g., a \code{\link{DTEData-class}}).}
}
\value{
For the accessor, a \code{\link{DTEData-class}} object. For the replacement,
an updated \code{\link{DOTSeqDataSets-class}} object.
}
\description{
These methods allow access to and replacement of the \code{\link{DTEData-class}}
object stored within a \code{\link{DOTSeqDataSets-class}} container.
}
\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
