% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{mapIDs}
\alias{mapIDs}
\title{Retrieve Gene Symbols from Ensembl or Ensembl Genomes}
\usage{
mapIDs(
  ensembl_ids,
  dataset,
  symbol_col = "external_gene_name",
  include_go = FALSE,
  mart_source = "ensembl",
  host = NULL
)
}
\arguments{
\item{ensembl_ids}{A character vector of Ensembl gene IDs to query.}

\item{dataset}{A string specifying the dataset name (e.g.,
\code{"hsapiens_gene_ensembl"}, \code{"athaliana_eg_gene"}).}

\item{symbol_col}{A string specifying the attribute to use as the
gene symbol. Common options include \code{hgnc_symbol},
\code{"external_gene_name"}, \code{description}. The default is
\code{"external_gene_name"}, which is widely used in vertebrate
datasets such as human and mouse.}

\item{include_go}{Logical; if \code{TRUE}, includes GO annotations
(\code{go_id}, \code{name_1006}, \code{namespace_1003}) in the output.}

\item{mart_source}{A string indicating the BioMart source. One of
\code{"ensembl"}, \code{"plants"}, \code{"fungi"}, \code{"protists"},
\code{"metazoa"}, or \code{"bacteria"}.}

\item{host}{Optional. A custom host URL (e.g., for archived Ensembl
versions).}
}
\value{
A data frame containing gene symbols for the input Ensembl
IDs. If \code{symbol_col} is unavailable, the \code{description}
field is used instead and renamed to match \code{symbol_col}.
}
\description{
Queries Ensembl or Ensembl Genomes BioMart databases to retrieve
gene symbols, descriptions, and optionally Gene Ontology (GO)
terms. Supports multiple organism groups including vertebrates,
plants, fungi, protists, metazoa, and bacteria.

If the specified \code{symbol_col} returns only \code{NA} values,
the function automatically falls back to using the
\code{description} field instead.
}
\examples{
# Human gene example
mapIDs(
    c("ENSG00000139618"),
    dataset = "hsapiens_gene_ensembl",
    mart_source = "ensembl"
)

# Arabidopsis gene example
# mapIDs(
#    c("AT1G01010"),
#    dataset = "athaliana_eg_gene",
#    symbol_col = "tair_symbol",
#    mart_source = "plants"
# )

# Plasmodium falciparum gene example with fallback
# mapIDs(
#    c("PF3D7_0100100"),
#    dataset = "pfalciparum_eg_gene",
#    mart_source = "protists"
# )

}
\references{
Durinck S, Spellman P, Birney E, Huber W (2009). Mapping identifiers
for the integration of genomic datasets with the R/Bioconductor
package biomaRt. Nature Protocols, 4, 1184–1191.
DOI: 10.1038/nprot.2009.97

Durinck S, Moreau Y, Kasprzyk A, Davis S, De Moor B, Brazma A,
Huber W (2005). BioMart and Bioconductor: a powerful link between
biological databases and microarray data analysis. Bioinformatics,
21, 3439–3440. DOI: 10.1093/bioinformatics/bti525
}
