% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDOT}
\alias{plotDOT}
\title{Generate Differential ORF Translation (DOT) Visualization Suite}
\usage{
plotDOT(
  plot_type = "volcano",
  results = NULL,
  data = NULL,
  id_mapping = FALSE,
  include_go = FALSE,
  gene_id = NULL,
  dou_params = list(est_col = "posterior", est_thresh = 1, signif_col = "lfsr",
    signif_thresh = 0.05, signif_ceil = 10, extreme_thresh = NULL),
  dte_params = list(est_col = "log2FoldChange", signif_col = "padj", signif_thresh =
    0.05),
  plot_params = list(top_hits = 20, color_by = "significance", rank_by = "significance",
    legend_position = "topright", order_by = NULL, flip_sign = FALSE),
  annotation_params = list(sorf_type = "uORF", dataset = "hsapiens_gene_ensembl",
    symbol_col = "hgnc_symbol", mart_source = "ensembl"),
  colors = list(dte = adjustcolor("#0072B2", alpha.f = 0.6), dou = adjustcolor("#E69F00",
    alpha.f = 0.6), both = adjustcolor("#CC79A7", alpha.f = 0.6), none =
    adjustcolor("grey80", alpha.f = 0.6), uorf = adjustcolor("#D73027", alpha.f = 0.6),
    morf = adjustcolor("#4575B4", alpha.f = 0.6), dorf = adjustcolor("#A6A6A6", alpha.f =
    0.6), low = "blue", middle = "white", high = "red", usage = "Set2"),
  force_new_device = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{plot_type}{Type of plot to generate. Options include
\code{"volcano"}, \code{"venn"}, \code{"composite"}, \code{"heatmap"},
and \code{"usage"}. Default is \code{"volcano"}.}

\item{results}{A data frame containing DOU and DTE estimates and
significance values. Required for all plots except \code{"usage"}.
Must include ORF-level identifiers and columns
specified in \code{dou_params} and \code{dte_params}.}

\item{data}{A \code{\link{DOUData-class}} object required for all
plots except for \code{"venn"}. Should contain \code{DOUResults} in
\code{rowData()} and post hoc results in the \code{interaction} slot.}

\item{id_mapping}{Optional input controlling gene symbol annotation.
Can be one of:
\itemize{
\item \code{FALSE} (default): disables annotation.
\item \code{TRUE}: triggers automatic annotation via BioMart
using \code{mapIDs()}.
\item a \code{data.frame}: a precomputed mapping of Ensembl IDs
to gene symbols, which can be reused across plots.
}
Used in volcano and heatmap plots to annotate genes with symbols.
If \code{TRUE}, annotation is attempted and fallback to Ensembl IDs
occurs if symbol coverage is low. Default is \code{FALSE}}

\item{include_go}{Logical; if \code{TRUE}, includes GO annotations
in \code{id_mapping}. Default is \code{FALSE}.}

\item{gene_id}{Character string specifying the gene ID for usage
plots. Default is \code{NULL}.}

\item{dou_params}{A named list of parameters for DOU filtering
and display:
\itemize{
\item{\code{est_col}: Column name for DOU effect size (e.g.,
\code{"posterior"})}
\item{\code{est_thresh}: Threshold for effect size significance}
\item{\code{signif_col}: Column name for DOU significance
(e.g., \code{"lfsr"})}
\item{\code{signif_thresh}: Threshold for significance}
\item{\code{signif_ceil}: Ceiling for -log10 significance
axis}
\item{\code{extreme_thresh}: Optional threshold for labeling
extreme points}
}}

\item{dte_params}{A named list of parameters for DTE filtering:
\itemize{
\item{\code{est_col}: Column name for DTE effect size (e.g.,
\code{"log2FoldChange"})}
\item{\code{signif_col}: Column name for DTE significance (e.g.,
\code{"padj"})}
\item{\code{signif_thresh}: Threshold for significance}
}}

\item{plot_params}{A named list controlling labeling of top hits:
\itemize{
\item{\code{top_hits}: Number of top hits to label or show in
volcano plot and heatmap}
\item{\code{color_by}:  How to color points. Options:
\itemize{
\item{\code{"significance"}: Based on DTE-only, DOU-only,
or both}
\item{\code{"orf_type"}: Based on ORF type (requires
\code{rowdata})}
}
.    }
\item{\code{rank_by}: Ranking method (\code{"significance"} or
\code{"score"})}
\item{\code{legend_position}: Character string specifying the
position of the legend in the volcano and composite scatter plots.
Options include: \code{"bottomright"}, \code{"bottom"},
\code{"bottomleft"}, \code{"left"}, \code{"topleft"},
\code{"top"}, \code{"topright"}, \code{"right"}, \code{"center"}.
Default is \code{"topright"}.}
\item{\code{order_by}: Optional character vector
specifying the order of conditions on the \code{"usage"}
plot x-axis.}
\item{\code{flip_sign}: Logical; if \code{TRUE}, flips the sign of DOU
estimates to align directionality with DTE. Default is \code{TRUE}.}
}}

\item{annotation_params}{A named list for BioMart annotation:
\itemize{
\item{\code{sorf_type}: Short ORF type (\code{"uORF"} or
\code{"dORF"})}
\item{\code{dataset}: Ensembl dataset name}
\item{\code{symbol_col}: Column name for gene symbols}
\item{\code{mart_source}: BioMart source (\code{"ensembl"},
\code{"plants"}, etc.)}
}}

\item{colors}{A named list of colors used across plots:
\itemize{
\item{\code{dte}, \code{dou}, \code{both}, \code{none}: for
significance-based coloring}
\item{\code{uorf}, \code{morf}, \code{dorf}: for ORF
type-based coloring}
\item{\code{low}, \code{middle}, \code{high}: for heatmap
gradient}
\item{\code{usage}: for condition-specific coloring}
}}

\item{force_new_device}{Logical; if \code{TRUE}, detects graphics
error and resets graphics state unconditionally.
Default is \code{TRUE}.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.
Default is \code{TRUE}.}
}
\value{
A data frame containing gene symbols retrieved from Ensembl,
used for labeling and heatmap visualization.
}
\description{
Generates a suite of visualizations to explore Differential ORF Usage
(DOU) and Translation Efficiency (DTE) results. Supports volcano
plots, Venn diagrams, composite scatter plots, heatmaps, and usage
plots. Integrates Ensembl gene symbols and highlights significant
ORFs based on empirical Bayes shrinkage (via the \pkg{ashr} package's
\code{\link[ashr]{ash}} function).
}
\details{
This function orchestrates multiple visualization components to
explore differential translation across ORFs. It uses
\code{\link{testDOU}} output to identify significant ORFs,
retrieves gene symbols via  \code{\link[biomaRt]{getBM}}, and generates
plots to summarize DOU and DTE relationships. The composite scatter
plot includes marginal distributions by ORF type, helping to
visualize the overlap and divergence between DTE and DOU signals.
The volcano plot highlights extreme and top-ranked ORFs, while
the heatmap summarizes DOU across top genes.
}
\examples{
# Example ORF-level results
results_df <- data.frame(
  orf_id = c(
    "ENSG00000139618.19:O001",
    "ENSG00000139618.19:O002",
    "ENSG00000157764.15:O003"
  ),
  lfsr = c(0.01, 0.2, 0.03),
  padj = c(0.02, 0.01, 0.1)
)

plotDOT(plot_type = "venn", results = results_df)

}
\references{
Durinck S, Spellman P, Birney E, Huber W (2009). Mapping identifiers
for the integration of genomic datasets with the R/Bioconductor
package biomaRt. Nature Protocols, 4, 1184–1191.
DOI: 10.1038/nprot.2009.97

Durinck S, Moreau Y, Kasprzyk A, Davis S, De Moor B, Brazma A,
Huber W (2005). BioMart and Bioconductor: a powerful link between
biological databases and microarray data analysis. Bioinformatics,
21, 3439–3440. DOI: 10.1093/bioinformatics/bti525

Larsson J, Gustafsson P (2018). “A Case Study in Fitting
Area-Proportional Euler Diagrams with Ellipses Using eulerr.”
In Proceedings of International Workshop on Set Visualization
and Reasoning, volume 2116, 84–91.
\url{https://ceur-ws.org/Vol-2116/paper7.pdf}
}
