% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_composite}
\alias{plot_composite}
\title{Plot Composite Scatter and Marginal Plots for DTE vs DOU}
\usage{
plot_composite(
  results,
  rowdata = NULL,
  color_by = c("significance", "orf_type"),
  marginal_plot_type = c("histogram", "density"),
  dou_estimates_col = "posterior",
  dou_signif_col = "lfsr",
  dte_estimates_col = "log2FoldChange",
  dte_signif_col = "padj",
  dou_signif_thresh = 0.05,
  dte_signif_thresh = 0.05,
  flip_sign = FALSE,
  lhist = 20,
  colors = list(dte = adjustcolor("#0072B2", alpha.f = 0.6), dou = adjustcolor("#E69F00",
    alpha.f = 0.6), both = adjustcolor("#CC79A7", alpha.f = 0.6), none =
    adjustcolor("grey80", alpha.f = 0.4), uorf = adjustcolor("#D73027", alpha.f = 0.6),
    morf = adjustcolor("#4575B4", alpha.f = 0.6), dorf = adjustcolor("#A6A6A6", alpha.f =
    0.6)),
  legend_position = "bottomright"
)
}
\arguments{
\item{results}{A data frame containing DTE and DOU post hoc
contrast results. Must include columns for DTE and DOU
estimates and their significance values.}

\item{rowdata}{Optional data frame containing ORF metadata,
with row names corresponding to \code{orf_id}. Must
include an \code{orf_type} column with values "uORF",
"mORF", or "dORF" if \code{color_by = "orf_type"}.}

\item{color_by}{Character string specifying how to color
points:
\itemize{
\item{\code{"significance"}: Colors by DTE-only,
DOU-only, both significant}
\item{\code{"orf_type"}: Colors by ORF type (requires
\code{rowdata})}
}
Default is \code{"significance"}.}

\item{marginal_plot_type}{Character string specifying the
type of marginal plot: \code{"histogram"} or \code{"density"}.
Default is \code{"density"}.}

\item{dou_estimates_col}{Column name for DOU posterior
estimates. Default is \code{"posterior"}.}

\item{dou_signif_col}{Column name for DOU significance values
(e.g., local false sign rate). Default is \code{"lfsr"}.}

\item{dte_estimates_col}{Column name for DTE estimates
(e.g., log2 fold-change). Default is \code{"log2FoldChange"}.}

\item{dte_signif_col}{Column name for DTE adjusted p-values.
Default is \code{"padj"}.}

\item{dou_signif_thresh}{Numeric threshold for DOU significance.
Default is \code{0.05}.}

\item{dte_signif_thresh}{Numeric threshold for DTE significance.
Default is \code{0.05}.}

\item{flip_sign}{Logical; if \code{TRUE}, flips the sign of
DOU estimates to align directionality with DTE. Default
is \code{FALSE}.}

\item{lhist}{Integer; number of bins for marginal histograms.
Default is \code{20}.}

\item{colors}{A named list of colors used for plotting. Must include:
\itemize{
\item{\code{dte}, \code{dou}, \code{both},
\code{none}: for significance-based coloring}
\item{\code{uorf}, \code{morf}, \code{dorf}: for ORF
type-based coloring}
}
Each value should be a valid color string or result of
\code{adjustcolor()}.}

\item{legend_position}{Position of the legend. Options include
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"},
\code{"left"}, \code{"topleft"}, \code{"top"},
\code{"topright"}, \code{"right"}, \code{"center"}.}
}
\value{
A composite plot consisting of:
\describe{
\item{Scatter plot}{
Displays DTE (log2 fold-change) vs DOU
(log-odds change) estimates, colored by
significance or ORF type.
}
\item{Marginal plots}{
Show the distribution of DTE and DOU estimates
along the top and right margins, using either
histograms or density curves.
}
}
Additionally, the function returns the Spearman correlation
between DTE and DOU estimates.
}
\description{
Visualizes the relationship between differential translation efficiency
(DTE) and differential ORF usage (DOU) using a scatter plot with
marginal histograms or density curves. Points can be colored by
significance (DTE, DOU, both) or by ORF type (uORF, mORF, dORF).
This plot helps assess overlap and divergence between DTE and DOU
signals across ORFs.
}
\details{
The function uses base R graphics and a custom layout matrix to
arrange the scatter and marginal plots. Coloring by significance
requires DTE and DOU significance columns. Coloring by ORF type
requires a metadata table with \code{orf_type} values.
}
\keyword{internal}
