% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeeDeeExperiment-internal-utils.R
\name{limma_list_for_dde}
\alias{limma_list_for_dde}
\title{Convert a \code{MArrayLM} object with multiple contrasts into a list of DE results
tables compatible with DeeDeeExperiment}
\usage{
limma_list_for_dde(fit, number = nrow(fit), sort.by = "none")
}
\arguments{
\item{fit}{A \code{MArrayLM} object, as produced by the \code{limma} workflow}

\item{number}{An integer specifying the maximum number of genes to extract
per contrast}

\item{sort.by}{A character string specifying which statistic to rank the
genes by. It must be one of the values accepted by the \code{sort.by} argument in
the \code{limma::topTable()} function. Defaults to "none".}
}
\value{
A named list of DE results tables, one per contrast. Each table
contains standardized columns and the list is annotated with metadata
indicating its package origin (\code{limma}).
}
\description{
This helper function extracts DE results for each contrast contained in a
\code{limma::MArrayLM} object and reformats them into a list of standardized data
frames suitable for integration in a \code{DeeDeeExperiment} object.
Each resulting data frame includes renamed columns: \code{logFC} to \code{log2FoldChange}
,\code{P.Value} to \code{pvalue}, and \code{adj.P.Val} to \code{padj}.
}
\details{
The function assumes that each column in \code{fit$coefficients} corresponds to
a contrast of interest. The names of the resulting list elements are taken
directly from \code{colnames(fit$coefficients)}. The names in the input object
must therefore accurately reflect the intended contrast names.
}
\examples{
data("de_limma", package = "DeeDeeExperiment")
new_limma_list <- limma_list_for_dde(de_limma)
}
\seealso{
\code{\link[limma:toptable]{limma::topTable()}}
}
