% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbour_offset.R
\name{local_offset_distance_with_background}
\alias{local_offset_distance_with_background}
\title{Neighbourhood offset}
\usage{
local_offset_distance_with_background(
  mat,
  tx,
  coords,
  tx_x = "x",
  tx_y = "y",
  feature_label = "gene",
  distance = 50,
  nbins = 200,
  cl = 1,
  verbose = FALSE
)
}
\arguments{
\item{mat}{A count matrix with genes as rows and cells as columns.}

\item{tx}{A transcript dataframe with x, y coordinates and qv values.}

\item{coords}{A dataframe with x, y coordinates of each cell as separate columns.}

\item{tx_x}{Column name for the x coordinates in the transcripts dataframe.}

\item{tx_y}{Column name for the y coordinates in the transcripts dataframe.}

\item{feature_label}{Column name for the gene of each transcript in the transcripts dataframe.}

\item{distance}{The maximum distance to consider for local background estimation.}

\item{nbins}{The number of bins to use for hexagonal binning, used for calculating background transcript contamination.}

\item{cl}{The number of cores to use for parallel processing.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\value{
A matrix of local background counts for each gene in each cell.
}
\description{
This function calculates the local neighbourhood offset together with ambient background for each cell in a count matrix.
}
\details{
The function calculates the offset used for each cell based on their local
neighbourhoods.In most cases you do not need to use this as denoist already
runs this internally but it is good for debugging if needed.
}
\examples{
# Load example data
set.seed(42)
mat <- matrix(rpois(1000, lambda = 10), nrow = 10, ncol = 100)
rownames(mat) <- paste0("gene", 1:10)
coords <- data.frame(x = rnorm(100), y = rnorm(100))
tx <- data.frame(x = c(rnorm(500), rnorm(500, 3)),
                 y = c(rnorm(500), rnorm(500, 3)),
                 qv = rep(30, 1000), gene = paste0('gene', 1:10))
# Run DenoIST
off_mat <- local_offset_distance_with_background(mat, tx, coords,
                                                 distance = 1, nbins = 50,
                                                 cl = 1, verbose = TRUE)
# Check results
print(off_mat[1:5, 1:5])
}
