% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{intermediateMat}
\alias{intermediateMat}
\title{Find the clustering matrix that we would get if we stopped the ARI merging
early}
\usage{
intermediateMat(merger, p = 1, average_n = NULL, n_steps = NULL)
}
\arguments{
\item{merger}{the result from having run \code{\link{Dune}}
on the dataset}

\item{p}{A value between 0 and 1. We stop when the metric used for merging has
improved by p of the final total improvement. Default to 1 (i.e running the full merging).}

\item{average_n}{Alternatively, you can specify the average number of clusters you
want to have.}

\item{n_steps}{Finally, you can specify the number of merging steps to
do before stopping.}
}
\value{
A data.frame with the same dimensions as the currentMat of the merger
argument, plus one column with cell names, related to the rownames of the
original input
}
\description{
Find the clustering matrix that we would get if we stopped the ARI merging
early
}
\details{
If more than one of \code{p},\code{average_n} and \code{n_steps} is specified,
then the order of preference is \code{n_steps}, then \code{average_n} then \code{p}.
}
\examples{
data("clusMat", package = "Dune")
merger <- Dune(clusMat = clusMat)
head(intermediateMat(merger, n_steps = 1))
}
