% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBSEA.R
\name{EBSEA}
\alias{EBSEA}
\title{Exon Based Startegy for Expression Analysis of genes}
\usage{
EBSEA(data, columnData, design, test = "Wald", contrasts = NULL, plot = FALSE)
}
\arguments{
\item{data}{A dataframe of raw exon-counts}

\item{columnData}{A dataframe indicated the groups of the samples.}

\item{design}{Design matrix (see more information od design
matrixes in DESeq2 reference manual)}

\item{test}{The statistical test to be carried out. It can be
either Wald or Likelihood Ratio Test. For further details about
the methods you can look into DESeq2 refernce manual. Default: Wald}

\item{contrasts}{a character vector with exactly three elements:
the name of a factor in the design formula, the name of the
numerator level for the fold change, and the name of the
denominator level for the fold change Default: NULL}

\item{plot}{A logical value indicating a volcano plot
is produced. Default: FALSE}
}
\value{
The function returns a list containing containing
exon and gene-level results. ExonTable is a data frame
containing an average expression, log2 fold-change,
p-value and adjusted p-value. GeneTable is a data frame
containing the gene-level p-value, and adjusted-value.
Other returned elements include the raw and normalised
exon-level read counts, group information and design matrix used.
}
\description{
EBSEA takes the filtered raw exon-level read counts
as input, normalizes and performs a two-group statistical
comparison with DESeq2. The exon-level results are
aggregated to the gene-level using empirical Brown’s method.
The samples in the two groups can be paired.
}
\examples{
# The exon-based analysis for unpaired samples can be performed as follows:
data(exonCounts)
group <- data.frame('group' = as.factor(c('G1', 'G1', 'G1', 'G2', 'G2', 'G2', 'G2')))
row.names(group) <- colnames(exonCounts)
design <- ~group
ebsea.out <- EBSEA(exonCounts, group, design)
# The exon-based analysis for paired samples with contrast provided can be performed as follows:
data(exonCounts)
group <- data.frame('group' = as.factor(c('G1', 'G1', 'G1', 'G2', 'G2', 'G2', 'G2')),
 'paired' = as.factor(c(1,2,3,1,2,3,3)))
row.names(group) <- colnames(exonCounts)
design <- ~group
contrastInfo <- c('group', 'G2', 'G1')
ebsea.out <- EBSEA(exonCounts, group, design, contrasts = contrastInfo)
}
\references{
Laiho, A., & Elo, L. L. (2014). A note on an
exon-based strategy to identify differentially expressed
genes in RNA-seq experiments. PloS One, 9(12), e115964.
}
