% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_coexp_expressionSet.R
\name{build_coexp_expressionSet}
\alias{build_coexp_expressionSet}
\title{Builds a coexpression network from an expressionSet}
\usage{
build_coexp_expressionSet(
  exprsSet,
  gene.list,
  method = "spearman",
  flag = "rank"
)
}
\arguments{
\item{exprsSet}{data class ExpressionSet}

\item{gene.list}{array of gene labels}

\item{method}{correlation method to use, default Spearman's rho}

\item{flag}{string to indicate if the network should be ranked}
}
\value{
net Matrix symmetric
}
\description{
The function generates a dense coexpression network from expression data stored in 
the expressionSet data type. Correlation coefficicents are used as to weight the edges
of the nodes (genes). Calls \code{\link{build_coexp_network}}.
}
\examples{
exprs <- matrix( rnorm(1000), ncol=10,byrow=TRUE)
gene.list <- paste('gene',1:100, sep='')
sample.list <- paste('sample',1:10, sep='')
rownames(exprs) <- gene.list
colnames(exprs) <- sample.list
network <- build_coexp_expressionSet(exprs, gene.list, method='pearson')


}
\keyword{ExpressionSet}
\keyword{coexpression}
\keyword{dense}
\keyword{expressionSet}
\keyword{network}
