% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_weighted_network.R
\name{build_weighted_network}
\alias{build_weighted_network}
\title{Builds a weighted network}
\usage{
build_weighted_network(data, list)
}
\arguments{
\item{data}{3-column matrix, each row a pair indicating a relationship or interaction, and the last column the weight}

\item{list}{string array of genes/labels/ids}
}
\value{
net matrix characterizing interactions
}
\description{
The function creates a gene-by-gene matrix with binary entries indicating interaction (1) 
or no interaction (0) between the genes.
}
\examples{
data <- cbind(edgeA=c('gene1','gene2'),edgeB=c('gene3','gene3'), weight=c(0.5, 0.9))
list <- c('gene1','gene2','gene3')
network <- build_weighted_network(data,list)


}
\keyword{gene-by-gene}
\keyword{interaction}
\keyword{network}
