% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_multifunc.R
\name{calculate_multifunc}
\alias{calculate_multifunc}
\title{Performing multifunctionality analysis}
\usage{
calculate_multifunc(genes.labels)
}
\arguments{
\item{genes.labels}{Annotation matrix}
}
\value{
gene.mfs Returns matrix with evaluation of gene function prediction by given labels:
}
\description{
The function performs multifunctionality analysis ([1]) 
for a set of annotated genes and creates a rank based 
optimallist. For annotations use an ontology that is 
large enough to serve as a prior (e.g. GO, Phenocarta).
}
\examples{
genes.labels <- matrix( sample(c(0,1), 100, replace=TRUE),ncol=10,nrow=10)
rownames(genes.labels) = paste('gene', 1:10, sep='')
colnames(genes.labels) = paste('label', 1:10, sep='')
mf <- calculate_multifunc(genes.labels)

}
\keyword{evaluation}
\keyword{function}
\keyword{gene}
\keyword{ontology}
\keyword{prediction}
