% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_gene_network.R
\name{make_gene_network}
\alias{make_gene_network}
\title{Creating gene-by-gene network}
\usage{
make_gene_network(data, list)
}
\arguments{
\item{data}{2-column matrix, each row a pair indicating a relationship or interaction}

\item{list}{string array of genes}
}
\value{
net matrix binary characterizing interactions
}
\description{
The function creates a gene-by-gene matrix with binary entries indicating interaction (1) 
or no interaction (0) between the genes.
}
\examples{
gene.list <- paste('gene', 1:100, sep='')
data <- matrix(0,nrow=100, ncol=2)
data[,1] <- sample(gene.list, 100)
data[,2] <- sample(gene.list, 100)
net <- make_gene_network(data, gene.list)


}
\keyword{gene-by-gene}
\keyword{interaction}
\keyword{network}
