% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_GBA.R
\name{run_GBA}
\alias{run_GBA}
\title{Performing 'Guilt by Association' Analysis}
\usage{
run_GBA(network, labels, min = 20, max = 1000, nfold = 3)
}
\arguments{
\item{network}{numeric array symmetric, gene-by-gene matrix}

\item{labels}{numeric array}

\item{min}{numeric value to limit gene function size}

\item{max}{numeric value to limit gene function size}

\item{nfold}{numeric value, default is 3}
}
\value{
list roc.sub, genes, auroc
}
\description{
The function runs and evaluates gene function prediction based on the 
'guilt by association'-principle using neighbor voting (\code{\link{neighbor_voting}})
[1]. As a measure of performance and significance of results, AUCs of all 
evaluated functional groups are calculated.
}
\examples{
genes.labels <- matrix( sample( c(0,1), 1000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:10, sep='')
net <- cor( matrix( rnorm(10000), ncol=100), method='spearman')
rownames(net) <- paste('gene', 1:100, sep='')
colnames(net) <- paste('gene', 1:100, sep='')

gba <- run_GBA(net, genes.labels, min=10) 

}
\keyword{association}
\keyword{by}
\keyword{cross}
\keyword{evaluation}
\keyword{function}
\keyword{gene}
\keyword{guilt}
\keyword{neighbor}
\keyword{prediction}
\keyword{validation}
\keyword{voting}
