% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSCollectionIndexclass.R
\docType{class}
\name{GSCollectionIndex}
\alias{GSCollectionIndex}
\alias{GSCollectionIndex-class}
\alias{$,GSCollectionIndex-method}
\alias{summary,GSCollectionIndex-method}
\alias{show,GSCollectionIndex-method}
\alias{getSetByName}
\alias{getSetByName,GSCollectionIndex-method}
\alias{getSetByID}
\alias{getSetByID,GSCollectionIndex-method}
\title{The GSCollectionIndex class}
\usage{
\S4method{$}{GSCollectionIndex}(x, name)

\S4method{summary}{GSCollectionIndex}(object)

\S4method{show}{GSCollectionIndex}(object)

getSetByName(object, set.name)

getSetByID(object, id)
}
\arguments{
\item{x}{GSCollectionIndex, the indexed gene set collection generated
from \code{\link{buildIdx}}, \code{\link{buildMSigDBIdx}}, 
\code{\link{buildKEGGIdx}},
\code{\link{buildGeneSetDBIdx}}, and \code{\link{buildCustomIdx}}.}

\item{name}{character, the slot name}

\item{object}{GSCollectionIndex, the indexed gene set collection generated
from \code{\link{buildIdx}}, \code{\link{buildMSigDBIdx}}, 
\code{\link{buildKEGGIdx}},
\code{\link{buildGeneSetDBIdx}}, and \code{\link{buildCustomIdx}}.}

\item{set.name}{character, a vector of gene set names as they appear in \code{\link{topSets}}.}

\item{id}{character, a vector of gene set IDs as they appears in the 
\code{\link{plotSummary}}.}
}
\value{
\code{$} returns the selected slot data.

\code{summary} does not return data.

\code{show} does not return data.

\code{getSetByName} returns a list of annotation records

\code{getSetByID} returns a list of the annotation records.
}
\description{
The \code{GSCollectionIndex} class stores an indexed gene set collection.

The operator \code{$} extracts a slot from an object of class 
GSCollectionIndex.

\code{summary} displays a brief summary of a gene set collection

\code{show} displays the details of a gene set collection

\code{getSetByName} retrieves the details of a given gene set 
indicated by name

\code{getSetByID} retrieves the details of a given gene set indicated by ID
}
\details{
The \code{GSCollectionIndex} is used by \code{buildIdx}, \code{buildCustomIdx},
\code{buildKEGGIdx}, \code{buildMSigDBIdx} and \code{buildGeneSetDBIdx}.
}
\section{Slots}{

\describe{
\item{\code{original}}{list, the original gene sets}

\item{\code{idx}}{list, the gene set indexes}

\item{\code{anno}}{data.frame, the annotations of the gene sets}

\item{\code{featureIDs}}{character, vector of the original Entrez IDs that are 
used in the indexing procedure}

\item{\code{species}}{character, the species name}

\item{\code{name}}{character, the name of the gene set collection}

\item{\code{label}}{character, a label to distnguish this collection}

\item{\code{version}}{character, the database version from which the collection was extracted}

\item{\code{date}}{character, the update/download date of the database
from other collections}
}}

\examples{
# Example of GSCollectionIndex
library(EGSEAdata)
data(il13.data)
v = il13.data$voom
gs.annots = buildIdx(entrezIDs=rownames(v$E), species="human", 
			msigdb.gsets="none", 
         kegg.updated=FALSE, kegg.exclude = c("Metabolism"))
print(gs.annots[[1]]$name)

# Example of summary
library(EGSEAdata)
data(il13.data)
v = il13.data$voom
gs.annots = buildIdx(entrezIDs=rownames(v$E), species="human", 
			msigdb.gsets="none", 
         kegg.updated=FALSE, kegg.exclude = c("Metabolism"))
summary(gs.annots[[1]])

# Example of show
library(EGSEAdata)
data(il13.data)
v = il13.data$voom
gs.annots = buildIdx(entrezIDs=rownames(v$E), species="human", 
			msigdb.gsets="none", 
         kegg.updated=FALSE, kegg.exclude = c("Metabolism"))
show(gs.annots[[1]])

# Example of getSetByName
library(EGSEAdata)
data(il13.data)
v = il13.data$voom
gs.annots = buildIdx(entrezIDs=rownames(v$E), species="human", 
			msigdb.gsets="none", 
         kegg.updated=FALSE, kegg.exclude = c("Metabolism"))
getSetByName(gs.annots[[1]], "Asthma")

# Example of getSetByID
library(EGSEAdata)
data(il13.data)
v = il13.data$voom
gs.annots = buildIdx(entrezIDs=rownames(v$E), species="human", 
			msigdb.gsets="none", 
         kegg.updated=FALSE, kegg.exclude = c("Metabolism"))
getSetByID(gs.annots[[1]], "hsa04060")

}
