% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SingleCellPipeline.R
\name{create_sce_from_dir}
\alias{create_sce_from_dir}
\title{Create \code{SingleCellExperiment} object from \code{FLAMES} output folder}
\usage{
create_sce_from_dir(outdir, annotation, quantification = "FLAMES")
}
\arguments{
\item{outdir}{The folder containing \code{FLAMES} output files}

\item{annotation}{the annotation file that was used to produce the output files}

\item{quantification}{(Optional)  the quantification method used to generate the 
output files (either "FLAMES" or "Oarfish".). If not specified, the function will 
attempt to determine the quantification method.}
}
\value{
a list of \code{SingleCellExperiment} objects if multiple transcript matrices were
found in the output folder, or a \code{SingleCellExperiment} object if only one were found
}
\description{
Create \code{SingleCellExperiment} object from \code{FLAMES} output folder
}
\examples{
outdir <- tempfile()
dir.create(outdir)
bc_allow <- file.path(outdir, "bc_allow.tsv")
genome_fa <- file.path(outdir, "rps24.fa")
R.utils::gunzip(
  filename = system.file("extdata", "bc_allow.tsv.gz", package = "FLAMES"),
  destname = bc_allow, remove = FALSE
)
R.utils::gunzip(
  filename = system.file("extdata", "rps24.fa.gz", package = "FLAMES"),
  destname = genome_fa, remove = FALSE
)
annotation <- system.file("extdata", "rps24.gtf.gz", package = "FLAMES")

sce <- sc_long_pipeline(
  genome_fa = genome_fa,
  fastq = system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES"),
  annotation = annotation,
  outdir = outdir,
  barcodes_file = bc_allow,
  config_file = create_config(
    outdir,
    pipeline_parameters.demultiplexer = "flexiplex",
    oarfish_quantification = FALSE
  )
)
sce_2 <- create_sce_from_dir(outdir, annotation)
}
