% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{flexiplex}
\alias{flexiplex}
\title{Rcpp port of flexiplex}
\usage{
flexiplex(
  reads_in,
  barcodes_file,
  bc_as_readid,
  max_bc_editdistance,
  max_flank_editdistance,
  pattern,
  reads_out,
  stats_out,
  bc_out,
  reverseCompliment,
  n_threads
)
}
\arguments{
\item{reads_in}{Input FASTQ or FASTA file}

\item{barcodes_file}{barcode allow-list file}

\item{bc_as_readid}{bool, whether to add the demultiplexed barcode to the
read ID field}

\item{max_bc_editdistance}{max edit distance for barcode '}

\item{max_flank_editdistance}{max edit distance for the flanking sequences '}

\item{pattern}{StringVector defining the barcode structure, see [find_barcode]}

\item{reads_out}{output file for demultiplexed reads}

\item{stats_out}{output file for demultiplexed stats}

\item{bc_out}{WIP}

\item{reverseCompliment}{bool, whether to reverse complement the reads after demultiplexing}

\item{n_threads}{number of threads to be used during demultiplexing}
}
\value{
integer return value. 0 represents normal return.
}
\description{
demultiplex reads with flexiplex, for detailed description, see
documentation for the original flexiplex: https://davidsongroup.github.io/flexiplex
}
