% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantification.R
\name{quantify_transcript}
\alias{quantify_transcript}
\title{Transcript quantification}
\usage{
quantify_transcript(
  annotation,
  outdir,
  config,
  pipeline = "sc_single_sample",
  ...
)
}
\arguments{
\item{annotation}{The file path to the annotation file in GFF3 format}

\item{outdir}{The path to directory to store all output files.}

\item{config}{Parsed FLAMES configurations.}

\item{pipeline}{The pipeline type as a character string, either \code{sc_single_sample} (single-cell, single-sample),}

\item{...}{Supply sample names as character vector (e.g. \code{samples = c("name1", "name2", ...)}) for muti-sample or bulk pipeline.
\code{bulk} (bulk, single or multi-sample), or \code{sc_multi_sample} (single-cell, multiple samples)}
}
\value{
A \code{SingleCellExperiment} object for single-cell pipeline, a list of \code{SingleCellExperiment} objects for multi-sample pipeline, or a \code{SummarizedExperiment} object for bulk pipeline.
}
\description{
Calculate the transcript count matrix by parsing the re-alignment file.
}
\keyword{internal}
