% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnView.R
\name{cnView}
\alias{cnView}
\title{Construct copy-number single sample plot}
\usage{
cnView(
  x,
  y = NULL,
  z = NULL,
  genome = "hg19",
  chr = "chr1",
  CNscale = "absolute",
  ideogram_txtAngle = 45,
  ideogram_txtSize = 5,
  plotLayer = NULL,
  ideogramLayer = NULL,
  out = "plot",
  segmentColor = NULL
)
}
\arguments{
\item{x}{Object of class data frame with rows representing copy number calls
from a single sample. The data frame must contain columns with the following
names "chromosome", "coordinate", "cn", and optionally "p_value"
(see details).}

\item{y}{Object of class data frame with rows representing cytogenetic bands
for a chromosome. The data frame must contain columns with the following
names "chrom", "chromStart", "chromEnd", "name", "gieStain" for plotting the
ideogram (optional: see details).}

\item{z}{Object of class data frame with row representing copy number segment
calls. The data frame must contain columns with the following names
"chromosome", "start", "end", "segmean" (optional: see details)}

\item{genome}{Character string specifying a valid UCSC genome (see details).}

\item{chr}{Character string specifying which chromosome to plot one of
"chr..." or "all"}

\item{CNscale}{Character string specifying if copy number calls supplied are
relative (i.e.copy neutral == 0) or absolute (i.e. copy neutral ==2). One of
"relative" or "absolute"}

\item{ideogram_txtAngle}{Integer specifying the angle of cytogenetic labels
on the ideogram subplot.}

\item{ideogram_txtSize}{Integer specifying the size of cytogenetic labels on
the ideogram subplot.}

\item{plotLayer}{Valid ggplot2 layer to be added to the copy number plot.}

\item{ideogramLayer}{Valid ggplot2 layer to be added to the ideogram
sub-plot.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}

\item{segmentColor}{Character string specifying the color of segment lines. Used only if 
Z is not null.}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a data frame construct a plot to display raw copy number calls for a
single sample.
}
\details{
cnView is able to plot in two modes specified via the `chr`
parameter, these modes are single chromosome view in which an ideogram is
displayed and genome view where chromosomes are faceted. For the single
chromosome view cytogenetic band information is required giving the
coordinate, stain, and name of each band. As a convenience cnView stores this
information for the following genomes "hg19", "hg38", "mm9", "mm10", and
"rn5". If the genome assembly supplied to the `genome` parameter is not one
of the 5 afore mentioned genome assemblies cnView will attempt to query the
UCSC MySQL database to retrieve this information. Alternatively the user can
manually supply this information as a data frame to the `y` parameter, input
to the `y` parameter take precedence of input to `genome`.

cnView is also able to represent p-values for copy-number calls if they are
supplied via the "p_value" column in the argument supplied to x. The presence
of this column in x will set a transparency value to copy-number calls with
calls of less significance becoming more transparent.

If it is available cnView can plot copy-number segment calls on top of raw
calls supplied to parameter `x` via the parameter `z`.
}
\examples{
# Create data
chromosome <- 'chr14'
coordinate <- sort(sample(0:106455000, size=2000, replace=FALSE))
cn <- c(rnorm(300, mean=3, sd=.2), rnorm(700, mean=2, sd=.2), rnorm(1000, mean=3, sd=.2))
data <- as.data.frame(cbind(chromosome, coordinate, cn))

# Plot raw copy number calls
cnView(data, chr='chr14', genome='hg19', ideogram_txtSize=4)
}
