% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickAnalysis.R
\name{filterWhippetEvents}
\alias{filterWhippetEvents}
\title{Filter out significant events from a whippet diff comparison}
\usage{
filterWhippetEvents(whippetDataSet, probability = 0.95, psiDelta = 0.1,
  eventTypes = "all", idList = NA, minCounts = NA, medianCounts = NA,
  sampleTable)
}
\arguments{
\item{whippetDataSet}{whippetDataSet generated from \code{readWhippetDataSet()}}

\item{probability}{minimum probability required to call event as significant}

\item{psiDelta}{minimum change in psi required to call an event as significant}

\item{eventTypes}{which event type to filter for? default = \code{"all"}}

\item{idList}{(optional) list of gene ids to filter for}

\item{minCounts}{minumum number of counts for all replicates
in at least one condition to call an event as significant}

\item{medianCounts}{median count for all replicates
in at least one condition to call an event as significant}

\item{sampleTable}{data.frame with sample names and conditions.
Only needed if filtering with counts.}
}
\value{
filtered whippet differential comparison data.frame
}
\description{
Filter out significant events from a whippet diff comparison
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{formatWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDIFFfiles}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetJNCfiles}},
  \code{\link{readWhippetPSIfiles}},
  \code{\link{whippetTranscriptChangeSummary}}
}
\author{
Beth Signal
}
