% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longestORF.R
\name{maxLocation}
\alias{maxLocation}
\title{Find the largest distance between two vectors of numbers
Helper function for get_orfs}
\usage{
maxLocation(startSite, stopSite, longest = 1)
}
\arguments{
\item{startSite}{vector of start sites - i.e Met amino acid positions}

\item{stopSite}{vector of stop sites - i.e Stop (*) amino acid positions}

\item{longest}{which pair to return (1 = longest pair, 2= 2nd longest pair etc.)}
}
\value{
sequential start site and end site with the greatest difference
}
\description{
Find the largest distance between two vectors of numbers
Helper function for get_orfs
}
\examples{
starts <- c(1,10,15,25)
stops <- c(4,16,50,55)
# longest start site = 25, longest stop site = 50
maxLocation(starts, stops, longest = 1)
starts <- c(1,10,15,25)
stops <- c(4,14,50,55)
# longest start site = 15, longest stop site = 50
maxLocation(starts, stops, longest = 1)
# 2nd longest start site = 10, 2nd longest stop site = 14
maxLocation(starts, stops, longest = 2)
}
\seealso{
Other ORF annotation: \code{\link{getOrfs}},
  \code{\link{getUOrfs}}, \code{\link{orfSimilarity}}
}
\author{
Beth Signal
}
