% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWhippetFiles.R
\name{readWhippetJNCfiles}
\alias{readWhippetJNCfiles}
\title{Read in a list of whippet .jnc.gz files and format as a GRanges object}
\usage{
readWhippetJNCfiles(files)
}
\arguments{
\item{files}{vector of *.jnc.gz file names}
}
\value{
GRanges object with junctions
}
\description{
Read in a list of whippet .jnc.gz files and format as a GRanges object
}
\examples{
whippetFiles <- list.files(system.file("extdata","whippet/",
package = "GeneStructureTools"), full.names = TRUE)
jncFiles <- whippetFiles[grep(".jnc", whippetFiles)]
whippetJNC <- readWhippetJNCfiles(jncFiles)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{filterWhippetEvents}},
  \code{\link{formatWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDIFFfiles}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetPSIfiles}},
  \code{\link{whippetTranscriptChangeSummary}}
}
\author{
Beth Signal
}
