% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummaryStats.R
\name{categoriseInteractions}
\alias{categoriseInteractions}
\title{Get the numbers of interaction types existing in your data}
\usage{
categoriseInteractions(GIObject, node.classes = NULL, viewpoints = NULL)
}
\arguments{
\item{GIObject}{A GInteractions object}

\item{node.classes}{Optional. All node.classes to include in the analysis.
Default: all node classes.}

\item{viewpoints}{Optional. If set will only consider interactions where at
least one anchor is of this node class. Default: all classes in node.classes.}
}
\value{
A data.frame.
}
\description{
Get the numbers of interaction types existing in your data
}
\examples{
library('GenomicRanges')
data(hic_example_data)
data(mm9_refseq_promoters)
mm9_refseq_grl = split(mm9_refseq_promoters, mm9_refseq_promoters$id)
annotateInteractions(hic_example_data, list(promoter=mm9_refseq_grl))
categoriseInteractions(hic_example_data)
}
