% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummaryStats.R
\name{plotCounts}
\alias{plotCounts}
\title{Plot a bar chart of the number of interactions supported by different numbers of reads in your data.}
\usage{
plotCounts(GIObject, normalise = FALSE, cut = 10)
}
\arguments{
\item{GIObject}{A GInteractions object.}

\item{normalise}{Logical. If TRUE, plots proportion of total reads instead of count.}

\item{cut}{Numeric, can be NULL. Default: 10. All interactions with counts > cut are consolidated into a single category.}
}
\value{
A ggplot2 plot
}
\description{
Plot a bar chart of the number of interactions supported by different numbers of reads in your data.
}
\examples{
data(hic_example_data)
plotCounts(hic_example_data)
plotCounts(hic_example_data, normalise=TRUE)
}
