% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_annotations.r
\docType{methods}
\name{summariseByFeatures}
\alias{summariseByFeatures}
\alias{summariseByFeatures,GInteractions-method}
\title{Summary statistics of interactions for a given feature set}
\usage{
summariseByFeatures(
  GIObject,
  features,
  feature.name,
  distance.method = "midpoint",
  annotate.self = FALSE
)

\S4method{summariseByFeatures}{GInteractions}(
  GIObject,
  features,
  feature.name,
  distance.method = "midpoint",
  annotate.self = FALSE
)
}
\arguments{
\item{GIObject}{An annotated GInteractions object}

\item{features}{A GRanges object containing the feature set}

\item{feature.name}{The name of the feature set}

\item{distance.method}{Method for calculating distances between anchors, see
?calculateDistances}

\item{annotate.self}{Logical. Indicates whether to annotate self interactions,
i.e. where a feature in `features` overlaps both anchors of an interaction.
 Default: FALSE.}
}
\value{
A data frame with one line for each range in `features'
}
\description{
This function will calculate summary statistics for each element in the
given feature set, including the number of interactions (the sum of all
interaction counts), number of unique interactions and number of trans-
(interchromosomal) interations.  It also returns some statistics for the 
distances of interactions for all interactions of the feature, and for the 
different interaction types e.g. promoter-distal.
}
\examples{
data('hic_example_data')
data('mm9_refseq_promoters')
annotateInteractions(hic_example_data, list(promoter = mm9_refseq_promoters))
summariseByFeatures(hic_example_data, mm9_refseq_promoters[1:10], 'promoter')
}
