% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleFeatures.R
\name{custom_TxDb_from_GTF}
\alias{custom_TxDb_from_GTF}
\title{Make custom TxDb object from a GTF/GFF file}
\usage{
custom_TxDb_from_GTF(gtfFile, genome = "hg19")
}
\arguments{
\item{gtfFile}{path to a gene annotation gtf file}

\item{genome}{a string denoting the genome name and version}
}
\value{
a TxDb object defined in the GenomicFeatures package.
}
\description{
This is a helper function for creating custom TxDb object from
a GTF/GFF file. Mitochondrial chromosome is excluded.
}
\examples{

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

txdb <- custom_TxDb_from_GTF(gtfFile, genome = "hg19")

}
\author{
Shuye Pu
}
