% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_boxplot_wo_outlier}
\alias{draw_boxplot_wo_outlier}
\title{Plot boxplot without outliers}
\usage{
draw_boxplot_wo_outlier(
  stat_df,
  xc = "Feature",
  yc = "Intensity",
  fc = xc,
  comp = list(c(1, 2)),
  stats = "wilcox.test",
  Xlab = xc,
  Ylab = yc,
  nf = 1
)
}
\arguments{
\item{stat_df}{a dataframe with column names c(xc, yc)}

\item{xc}{a string denoting column name for grouping}

\item{yc}{a string denoting column name for numeric data to be plotted}

\item{fc}{a string denoting column name for sub-grouping}

\item{comp}{a list of vectors denoting pair-wise comparisons to be performed
between groups}

\item{stats}{the name of pair-wise statistical tests, like t.test or
wilcox.test}

\item{Xlab}{a string for x-axis label}

\item{Ylab}{a string for y-axis label}

\item{nf}{a integer normalizing factor for correct count of observations when
the data table has two factors, such as those produced by `pivot_longer`,
equals to the number of factors}
}
\value{
a ggplot object
}
\description{
Plot boxplot without outliers, useful when outliers have a wide
range and the median is squeezed at the bottom of the plot. The p-value
significance level is the same as those in
\code{\link{draw_boxplot_by_factor}}, but not displayed.
}
\examples{
stat_df <- data.frame(
    Feature = rep(c("A", "B"), c(20, 30)),
    Intensity = c(rnorm(20, 2), rnorm(30, 3))
)

p <- draw_boxplot_wo_outlier(stat_df,
    xc = "Feature", yc = "Intensity",
    Ylab = "Signal Intensity"
)
p

}
