% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleDataMatrix.R
\name{impute_hm}
\alias{impute_hm}
\title{Impute missing values}
\usage{
impute_hm(fullmatrix, verbose = FALSE)
}
\arguments{
\item{fullmatrix}{a numeric matrix}

\item{verbose}{logical, whether to output additional information}
}
\value{
a numeric matrix
}
\description{
Replace 0 and missing values in a sparse non-negative matrix
with half of minimum of non-zero values, to avoid use of arbitrary pseudo
numbers, and to allow computing ratios and log transformation of matrices.
When a matrix is sparse (assuming it has many all-zero rows and few all-zero
columns), the half of minimum of non-zero values is a number that is small
enough so that is will not distort the data too much (comparing to a pseudo
count = 1), but large enough to avoid huge ratios when used as a denominator.
}
\examples{
fullMatrix <- matrix(rlnorm(100), ncol = 10)
for (i in 5:6) {
    fullMatrix[i - 1, 4:7] <- 0
}

imp <- GenomicPlot:::impute_hm(fullMatrix, verbose = TRUE)

}
\author{
Shuye Pu
}
\keyword{internal}
