% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parallel.R
\name{parallel_countOverlaps}
\alias{parallel_countOverlaps}
\title{Parallel execution of countOverlaps}
\usage{
parallel_countOverlaps(grange_list, tileBins, nc = 2, switch = FALSE)
}
\arguments{
\item{grange_list}{a list of GRanges objects.}

\item{tileBins}{a GRanges object of tiled genome}

\item{nc}{integer, number of cores for parallel processing}

\item{switch}{logical, switch the order of query and feature}
}
\value{
a list of numeric vectors
}
\description{
Function for parallel computation of countOverlaps function in
the GenomicRanges package
}
\examples{
bedQueryFiles <- c(
    system.file("extdata", "test_chip_peak_chr19.narrowPeak",
        package = "GenomicPlot"
    ),
    system.file("extdata", "test_chip_peak_chr19.bed",
        package = "GenomicPlot"),
    system.file("extdata", "test_clip_peak_chr19.bed",
        package = "GenomicPlot")
)
names(bedQueryFiles) <- c("NarrowPeak", "SummitPeak", "iCLIPPeak")

bedimportParams <- setImportParams(
    offset = 0, fix_width = 100, fix_point = "center", norm = FALSE,
    useScore = FALSE, outRle = FALSE, useSizeFactor = FALSE, genome = "hg19"
)

out_list <- handle_input(
    inputFiles = bedQueryFiles,
    importParams = bedimportParams, verbose = TRUE, nc = 2
)

chromInfo <- circlize::read.chromInfo(species = "hg19")$df
seqi <- Seqinfo(seqnames = chromInfo$chr, seqlengths = chromInfo$end,
               isCircular = rep(FALSE, nrow(chromInfo)),
               genome = "hg19")
grange_list <- lapply(out_list, function(x) x$query)
tilewidth <- 100000
tileBins <- tileGenome(seqi,
    tilewidth = tilewidth,
    cut.last.tile.in.chrom = TRUE
)

score_list1 <- parallel_countOverlaps(grange_list, tileBins, nc = 2)
dplyr::glimpse(score_list1)

}
\author{
Shuye Pu
}
