% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreTest.R
\docType{methods}
\name{BGScoreTest}
\alias{BGScoreTest}
\alias{BGScoreTest,NanoStringGeoMxSet-method}
\alias{BGScoreTest,matrix-method}
\title{Testing for features above the background}
\usage{
BGScoreTest(object, ...)

\S4method{BGScoreTest}{NanoStringGeoMxSet}(
  object,
  split = FALSE,
  adj = 1,
  removeoutlier = FALSE,
  useprior = FALSE
)

\S4method{BGScoreTest}{matrix}(
  object,
  BGmod,
  adj = 1,
  probenum,
  removeoutlier = FALSE,
  useprior = FALSE
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{split}{indicator variable on whether it is for multiple slides (Yes, TRUE; No, FALSE)}

\item{adj}{adjustment factor for the number of feature in each gene, default =1 i.e.
each target only consists of one probe}

\item{removeoutlier}{whether to remove outlier}

\item{useprior}{whether to use the prior that the expression level of background follows a Beta distribution,
leading to a more conservative test}

\item{BGmod}{a list of sizefact, sizefact, and countmat}

\item{probenum}{a vector of numbers of probes in each gene}
}
\value{
a valid GeoMx S4 object including the following items
\itemize{
  \item pvalues - Background score test pvalues, in featureData
  \item scores - Background score test statistics, in featureData
}

if split is TRUE, a valid GeoMx S4 object including the following items
\itemize{
  \item pvalues_XX - Background score test pvalues vector, column name (denoted as XX) the same as slide names, in featureData
  \item scores_XX - Background score test statistics vector, column name (denoted as XX) the same as slide names, in featureData
}

a list of following items
\itemize{
  \item pvalues - Background score test pvalues
  \item scores - Background score test statistics
}
}
\description{
Testing for features above the background using Poisson background model as reference

Testing for features above the background using Poisson background model as reference
}
\examples{

data(demoData)
demoData <- fitPoisBG(demoData, size_scale = "sum")
demoData <- aggreprobe(demoData, use = "cor")
demoData <- BGScoreTest(demoData, adj = 1, useprior = FALSE)
demoData <- fitPoisBG(demoData, size_scale = "sum", groupvar = "slide name")
demoData <- BGScoreTest(demoData, adj = 1, useprior = TRUE, split = TRUE)

}
