% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreTest.R
\docType{methods}
\name{BGScoreTest_sp}
\alias{BGScoreTest_sp}
\alias{BGScoreTest_sp,matrix-method}
\title{Testing for features above the background, multiple slides case}
\usage{
BGScoreTest_sp(object, ...)

\S4method{BGScoreTest_sp}{matrix}(
  object,
  BGmod,
  adj = 1,
  probenum,
  removeoutlier = FALSE,
  useprior = FALSE
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{BGmod}{fitted background model, multiple slides case}

\item{adj}{adjustment factor for the number of probes in each feature, default =1 i.e.
each target only consists of one probe}

\item{probenum}{a vector of numbers of probes in each gene}

\item{removeoutlier}{whether to remove outlier}

\item{useprior}{whether to use the prior that the expression level of background follows the Beta distribution,
leading to a more conservative test}
}
\value{
a list of following items
\itemize{
  \item pvalues - Background score test pvalues matrix, columns the same as slide names
  \item scores_sp - Background score test statistics matrix, columns the same as slide names
}
}
\description{
Testing for features above the background using Poisson background model as reference, multiple slides case
}
