% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBthDE.R
\docType{methods}
\name{fitNBthDE}
\alias{fitNBthDE}
\alias{fitNBthDE,NanoStringGeoMxSet-method}
\alias{fitNBthDE,matrix-method}
\title{Negative Binomial threshold model for differential expression analysis}
\usage{
fitNBthDE(object, ...)

\S4method{fitNBthDE}{NanoStringGeoMxSet}(
  object,
  form,
  split,
  ROIs_high = NULL,
  features_high = NULL,
  features_all = NULL,
  sizefact_start = NULL,
  sizefact_BG = NULL,
  threshold_mean = NULL,
  preci2 = 10000,
  lower_threshold = 0.01,
  prior_type = c("contrast", "equal"),
  sizefactrec = TRUE,
  size_scale = c("sum", "first"),
  sizescalebythreshold = FALSE,
  iterations = 2,
  covrob = FALSE,
  preci1con = 1/25,
  cutoff = 10,
  confac = 1
)

\S4method{fitNBthDE}{matrix}(
  form,
  annot,
  object,
  probenum,
  features_high,
  features_all,
  sizefact_start,
  sizefact_BG,
  threshold_mean,
  preci2 = 10000,
  lower_threshold = 0.01,
  prior_type = c("contrast", "equal"),
  sizefactrec = TRUE,
  size_scale = c("sum", "first"),
  sizescalebythreshold = FALSE,
  iterations = 2,
  covrob = FALSE,
  preci1con = 1/25,
  cutoff = 10,
  confac = 1
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{form}{model formula}

\item{split}{indicator variable on whether it is for multiple slides (Yes, TRUE; No, FALSE)}

\item{ROIs_high}{ROIs with high expressions defined based on featfact and featfact}

\item{features_high}{subset of features which are well above the background}

\item{features_all}{full list of features}

\item{sizefact_start}{initial value for size factors}

\item{sizefact_BG}{size factor for background}

\item{threshold_mean}{average threshold level}

\item{preci2}{precision for the background, default=10000}

\item{lower_threshold}{lower limit for the threshold, default=0.01}

\item{prior_type}{empirical bayes prior type, choose from c("contrast", "equal")}

\item{sizefactrec}{whether to recalculate sizefact, default=TRUE}

\item{size_scale}{method to scale the sizefact, sum(sizefact)=1 when size_scale="sum", sizefact[1]=1 when size_scale="first"}

\item{sizescalebythreshold}{XXXX, default = FALSE}

\item{iterations}{how many iterations need to run to get final results, default=2,
the first iteration apply the model only on features_high and construct the prior then refit the model using this prior for all genes.}

\item{covrob}{whether to use robust covariance in calculating covariance. default=FALSE}

\item{preci1con}{The user input constant term in specifying precision matrix 1, default=1/25}

\item{cutoff}{term in calculating precision matrix 1, default=10}

\item{confac}{The user input factor for contrast in precision matrix 1, default=1}

\item{annot}{annotations files with variables in the formula}

\item{probenum}{a vector of numbers of probes in each gene, default = rep(1, NROW(object))}
}
\value{
a list of
\itemize{
  \item X, design matrix
  \item para0, estimated parameters for the first iteration, including regression coefficients, r and threshold in rows and features in columns
  \item para, estimated parameters, including regression coefficients, r and threshold in rows and features in columns
  \item sizefact, estimated sizefact
  \item sizefact0, estimated sizefact in iter=1
  \item preci1, precision matrix for regression coefficients estimated in iter=1
  \item Im0, Information matrix of parameters in iter=1
  \item Im, Information matrix of parameters in iter=2
  \item conv0, vector of convergence for iter=1, 0 converged, 1 not converged
  \item conv, vector of convergence for iter=2, 0 converged, 1 not converged
  \item features_high, same as the input features_high
  \item features_all, same as the input features_all
}

a list of
\itemize{
  \item X, design matrix
  \item para0, estimated parameters for the first iteration, including regression coefficients, r and threshold in rows and features in columns
  \item para, estimated parameters, including regression coefficients, r and threshold in rows and features in columns
  \item sizefact, estimated sizefact
  \item sizefact0, estimated sizefact in iter=1
  \item preci1, precision matrix for regression coefficients estimated in iter=1
  \item Im0, Information matrix of parameters in iter=1
  \item Im, Information matrix of parameters in iter=2
  \item conv0, vector of convergence for iter=1, 0 converged, 1 not converged
  \item conv, vector of convergence for iter=2, 0 converged, 1 not converged
  \item features_high, same as the input features_high
  \item features_all, same as the input features_all
}
}
\description{
Negative Binomial threshold model for differential expression analysis

Negative Binomial threshold model for differential expression analysis
}
\examples{

library(Biobase)
library(dplyr)
data(demoData)
demoData <- demoData[, c(1:5, 33:37)]
demoData <- fitPoisBG(demoData, size_scale = "sum")
demoData <- aggreprobe(demoData, use = "cor")
demoData <- BGScoreTest(demoData)
demoData$slidename <- substr(demoData[["slide name"]], 12, 17)
thmean <- 1 * mean(fData(demoData)$featfact, na.rm = TRUE)
demo_pos <- demoData[which(!fData(demoData)$CodeClass == "Negative"), ]
demo_neg <- demoData[which(fData(demoData)$CodeClass == "Negative"), ]
sc1_scores <- fData(demo_pos)[, "scores"]
names(sc1_scores) <- fData(demo_pos)[, "TargetName"]
features_high <- ((sc1_scores > quantile(sc1_scores, probs = 0.4)) &
   (sc1_scores < quantile(sc1_scores, probs = 0.95))) |>
    which() |>
    names()
set.seed(123)
demoData <- fitNBth(demoData,
                    features_high = features_high,
                    sizefact_BG = demo_neg$sizefact,
                    threshold_start = thmean,
                    iterations = 5,
                    start_para = c(200, 1),
                    lower_sizefact = 0,
                    lower_threshold = 100,
                    tol = 1e-8)
ROIs_high <- sampleNames(demoData)[which(demoData$sizefact_fitNBth * thmean > 2)]
features_all <- rownames(demo_pos)

pData(demoData)$group <- c(rep(1, 5), rep(2, 5))

NBthDEmod1 <- fitNBthDE(
    form = ~group,
    split = FALSE,
    object = demoData,
    ROIs_high = ROIs_high,
    features_high = features_high,
    features_all = features_all,
    sizefact_start = demoData[, ROIs_high][["sizefact_fitNBth"]],
    sizefact_BG = demoData[, ROIs_high][["sizefact"]],
    preci2 = 10000,
    prior_type = "contrast",
    covrob = FALSE,
    preci1con = 1/25,
    sizescalebythreshold = TRUE
)


}
