% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auto_WGCNA.R
\name{Auto_WGCNA}
\alias{Auto_WGCNA}
\title{Carries out WGCNA with default settings or custom settings}
\usage{
Auto_WGCNA(
  datExpr,
  colname_correct = TRUE,
  minModuleSize = 10,
  deepSplit = 4,
  networkType = "signed hybrid",
  TOMType = "unsigned",
  corFnc = "bicor",
  mergeCutHeight = 0.25,
  sft_RsquaredCut = 0.85,
  removeFirst = FALSE,
  reassignThreshold = 1e-06,
  maxBlockSize = 25000,
  nThreads = NULL
)
}
\arguments{
\item{datExpr}{ Expression data. A matrix (preferred) or 
data frame in which columns are genes and rows ar samples. NAs are
allowed, but not too many. See \code{checkMissingData} below and details.}

\item{colname_correct}{a logical value. If TRUE (default), "." in gene 
names will be replaced
with "-". This corrects a name change that is induced by R when creating 
a data.frame. If FALSE,
no changes will be made.}

\item{minModuleSize}{ minimum module size for module detection. See
\code{\link[dynamicTreeCut]{cutreeDynamic}} for more details.  }

\item{deepSplit}{ integer value between 0 and 4. Provides a simplified control over how sensitive
module detection should be to module splitting, with 0 least and 4 most sensitive. See
\code{\link[dynamicTreeCut]{cutreeDynamic}} for more details. }

\item{networkType}{ network type. Allowed values are (unique abbreviations of) \code{"unsigned"},
\code{"signed"}, \code{"signed hybrid"}. See \code{\link[WGCNA]{adjacency}}. }

\item{TOMType}{ one of \code{"none"}, \code{"unsigned"}, \code{"signed"}. If \code{"none"}, adjacency
will be used for clustering. If \code{"unsigned"}, the standard TOM will be used (more generally, TOM
function will receive the adjacency as input). If \code{"signed"}, TOM will keep track of the sign of
correlations between neighbors. }

\item{corFnc}{the correlation function to be used in adjacency calculation. }

\item{mergeCutHeight}{ dendrogram cut height for module merging. }

\item{sft_RsquaredCut}{desired minimum scale free topology fitting 
index R^2.
Default is 0.80.}

\item{removeFirst}{ should the first bin be removed from the connectivity histogram? }

\item{reassignThreshold}{ p-value ratio threshold for reassigning genes between modules. See Details. }

\item{maxBlockSize}{integer giving maximum block size for module detection. Ignored if \code{blocks}
above is non-NULL. Otherwise, if the number of genes in \code{datExpr} exceeds \code{maxBlockSize}, genes
will be pre-clustered into blocks whose size should not exceed \code{maxBlockSize}. }

\item{nThreads}{ non-negative integer specifying the number of parallel threads to be used by certain
parts of correlation calculations. This option only has an effect on systems on which a POSIX thread
library is available (which currently includes Linux and Mac OSX, but excludes Windows). 
If zero, the number of online processors will be used if it can be determined dynamically, otherwise
correlation calculations will use 2 threads. }
}
\value{
Returns a lists containing network input parameters used 
for WGCNA,
WGCNA module information, and quality control plots.
}
\description{
Carries out WGCNA with default settings or custom settings
}
\note{
This is a wrapper for WGCNA.
}
\examples{
sample_dat_dir<-system.file("extdata", "sample_dat.Rdata", 
package = "GmicR", mustWork = TRUE)
load(sample_dat_dir)
GMIC_Builder<-Auto_WGCNA(sample_dat, mergeCutHeight = 0.35, 
minModuleSize = 10)
}
\seealso{
\code{\link[WGCNA]{blockwiseModules}}

\code{\link[WGCNA]{adjacency}}
}
