% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerdata.R
\name{centerdata}
\alias{centerdata}
\title{Centering Transposable Data}
\usage{
centerdata(datamat, N)
}
\arguments{
\item{datamat}{numeric matrix containing the transposable data.}

\item{N}{positive integer number indicating the sample size, e.g., the
number of subjects.}
}
\value{
Returns a matrix of the same size as \code{datamat}.
}
\description{
This function centers the transposable data around their sample mean matrix.
}
\details{
It is assumed that there are \code{nrow(datamat)} row variables and
\code{ncol(datamat)}/\code{N} column variables in \code{datamat}. Further,
\code{datamat} should be written in such a way that every
\code{ncol(datamat)}/\code{N} consecutive columns belong to the same subject
and the order of the column variables in each block is preserved across
subjects.
}
\examples{
data(VEGFmouse)
## Centering the VEGF dataset around the sample mean matrix.
VEGFcen <- centerdata(datamat = VEGFmouse, N = 40)
}
\seealso{
\code{\link{covmat.hat}} and \code{\link{covmat.ts}}.
}
\author{
Anestis Touloumis
}
