% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_partial_cor.R
\name{non_partial_cor}
\alias{non_partial_cor}
\title{Non-partial correlaton analysis}
\usage{
non_partial_cor(data = NULL, class_label = NULL, id = NULL,
  method = "pearson", p_val = NULL, permutation = 1000,
  permutation_thres = 0.05)
}
\arguments{
\item{data}{This is a matrix of expression from all biomolecules and all samples.}

\item{class_label}{this is a binary array with 0 for group 1 and 1 for group 2.}

\item{id}{This is an array of biomolecule IDs.}

\item{method}{This is a character string indicating which correlation coefficient is
to be computed. The options are either "pearson" as the default or "spearman".}

\item{p_val}{This is optional, it is a dataframe containing p-value for each biomolecule.}

\item{permutation}{This is a positive integer representing the desired number of permutations, 
default is 1000.}

\item{permutation_thres}{This is a threshold for permutation. The defalut is 0.05 to make 95 
percent confidence..}
}
\value{
A list containing a score table with "ID", "P_value", "Node_Degree", "Activity_Score"
         and a differential network table with "Node1", "Node2", the binary link value and the  
         weight link value.
}
\description{
A method that integrates differential expression (DE) analysis
    and differential network (DN) analysis to select biomarker candidates for
    cancer studies. non_partial_cor is a one step function for user
    to perform the analysis based on typical correlation analysis, no pre-processing step 
    required.
}
\examples{
non_partial_cor(data = Met_GU, class_label = Met_Group_GU, id = Met_name_GU,
                        method = "pearson", permutation = 1000, permutation_thres = 0.05)
}
