% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collision-removal.R
\name{realign_after_collisions}
\alias{realign_after_collisions}
\title{Re-aligns matrices of other quantification types based on the processed
sequence count matrix.}
\usage{
realign_after_collisions(
  sc_matrix,
  other_matrices,
  sample_column = pcr_id_column()
)
}
\arguments{
\item{sc_matrix}{The sequence count matrix already processed for collisions
via \code{remove_collisions()}}

\item{other_matrices}{A named list of matrices to re-align. Names in the list
must be quantification types (\code{quantification_types()}) except
"seqCount".}

\item{sample_column}{The name of the column containing the sample identifier}
}
\value{
A named list with re-aligned matrices
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
This function should be used to keep data consistent among the same analysis:
if for some reason you removed the collisions by passing only the sequence
count matrix to \code{remove_collisions()}, you should call this
function afterwards, providing a list of other quantification matrices.
NOTE: if you provided a list of several quantification types to
\code{remove_collisions()} before, there is no need to call this function.
}
\details{
For more details on how to use collision removal functionality:
\code{vignette("workflow_start", package = "ISAnalytics")}
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
separated <- separate_quant_matrices(
    integration_matrices
)
no_coll <- remove_collisions(
    x = separated$seqCount,
    association_file = association_file,
    quant_cols = c(seqCount = "Value"),
    report_path = NULL
)
realigned <- realign_after_collisions(
    sc_matrix = no_coll,
    other_matrices = list(fragmentEstimate = separated$fragmentEstimate)
)
realigned
}
\seealso{
\code{\link{remove_collisions}}

Other Data cleaning and pre-processing: 
\code{\link{aggregate_metadata}()},
\code{\link{aggregate_values_by_key}()},
\code{\link{compute_near_integrations}()},
\code{\link{default_meta_agg}()},
\code{\link{outlier_filter}()},
\code{\link{outliers_by_pool_fragments}()},
\code{\link{purity_filter}()},
\code{\link{remove_collisions}()},
\code{\link{threshold_filter}()}
}
\concept{Data cleaning and pre-processing}
