% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhCreateMAE.R
\name{lhCreateMAE}
\alias{lhCreateMAE}
\title{lhCreateMAE: Create a MultiAssayExperiment 
with Methylation and Expression Data}
\usage{
lhCreateMAE(
  xDat,
  yDat,
  xName = "methylation",
  yName = "expression",
  colData = NULL
)
}
\arguments{
\item{xDat}{A numeric matrix containing methylation data 
(features in rows, samples in columns).}

\item{yDat}{A numeric matrix containing expression data 
(features in rows, samples in columns).}

\item{xName}{A string specifying the name of the methylation dataset. 
Default: "methylation".}

\item{yName}{A string specifying the name of the expression dataset. 
Default: "expression".}

\item{colData}{(Optional) A DataFrame containing sample-level metadata. 
Default: NULL.}
}
\value{
A MultiAssayExperiment object containing the provided datasets 
with sample metadata.
}
\description{
This function constructs a MultiAssayExperiment 
object using methylation 
and expression data, automatically ensuring
consistency in sample names, 
feature names, and exposing dataset names.
It internally uses 
\code{checkPairing} to validate that the provided
datasets have matching 
row and column names.
}
\examples{

library(MultiAssayExperiment)

# Create synthetic methylation and expression data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))

expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- colnames(methylData)
rownames(expresData) <- rownames(methylData)

# Create sample metadata
colDat <- data.frame(sampleID = colnames(methylData),
name = letters[1:ncol(methylData)])
rownames(colDat) <- colDat$sampleID

# Construct MultiAssayExperiment
mae <- lhCreateMAE(methylData, expresData, colData = colDat)

# Display dataset names
names(experiments(mae))

}
\keyword{Data}
\keyword{Integration,}
\keyword{MultiAssayExperiment,}
\keyword{Omics}
