% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGenesMat.R
\name{plotGenesMat}
\alias{plotGenesMat}
\title{plotGenesMat}
\usage{
plotGenesMat(
  mae,
  geneNames = NULL,
  fileName = "Scatplot_Sel_Genes.pdf",
  text4Title = NULL,
  x1 = 1/3,
  x2 = 2/3,
  y1 = NULL,
  y2 = NULL,
  percY1 = 1/3,
  percY2 = 2/3,
  plotGrid = TRUE,
  logicSc = NULL,
  saveToPDF = FALSE,
  plotsPerPage = 9
)
}
\arguments{
\item{mae}{A MultiAssayExperiment object containing the methylation
and expression data.}

\item{geneNames}{A character vector of gene names to plot. 
If NULL, all genes are plotted.}

\item{fileName}{The name of the file used to save the results as a PDF.
If NULL, the plot is displayed on the screen.}

\item{text4Title}{An optional title for the plot, incorporating the gene name
and L-shape score. Defaults to NULL.}

\item{x1}{The x-coordinate of vertical points on the X-axis. 
Expected to contain methylation values ranging between 0 and 1,
with default values set to 1/3 and 2/3.}

\item{x2}{The x-coordinate of vertical points on the X-axis.
Expected to contain methylation values ranging between 0 and 1,
with default values set to 1/3 and 2/3.}

\item{y1}{The y-coordinate of vertical points on the Y-axis.
If NULL, these are set to the percentiles of yVec 
defined by percY1 and percY2.}

\item{y2}{The y-coordinate of vertical points on the Y-axis.
If NULL, these are set to the percentiles of yVec 
defined by percY1 and percY2.}

\item{percY1}{Values used as defaults for y1 when it is set to NULL.}

\item{percY2}{Values used as defaults for y2 when it is set to NULL.}

\item{plotGrid}{A logical value; defaults to TRUE, indicating 
whether to plot gridlines on the graph.}

\item{logicSc}{A numeric score representing the L-shape score. 
Defaults to NULL.}

\item{saveToPDF}{Logical, if TRUE, saves the plots to a PDF file 
specified by fileName. If FALSE (default), plots are displayed 
interactively without saving.}

\item{plotsPerPage}{A numeric value indicating the number of plots
to be printed in each page. Default set to 9.}
}
\value{
a pdf with scatterplots for all genes
}
\description{
\code{plotGenesMat} wrapper function for plotting the scatterplots associated
with two matrices.
}
\examples{
# Methylation data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))
# Expression data
expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- paste0("samp", 1:ncol(methylData))
rownames(expresData) <- paste0("gene", 1:nrow(methylData))
# ColData
colDat <- data.frame(
sampleID = colnames(methylData),
name = letters[1:ncol(methylData)])

rownames(colDat) <- colDat$sampleID
mae <- MultiAssayExperiment::MultiAssayExperiment(
    experiments = list(
        methylation = methylData,
        expression = expresData
    ),
    colData = colDat
) 
selectedGenes <- c("gene1", "gene5")
plotGenesMat(mae, geneNames = selectedGenes,
saveToPDF = FALSE)

}
\keyword{gene}
\keyword{matrix}
\keyword{plot}
\keyword{scatterplot}
