% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LimROTS.r
\name{LimROTS}
\alias{LimROTS}
\title{\code{LimROTS}: A Hybrid Method Integrating Empirical Bayes and
Reproducibility-Optimized Statistics for Robust
Differential Expression Analysis}
\usage{
LimROTS(
  x,
  niter = 1000,
  K = NULL,
  a1 = NULL,
  a2 = NULL,
  log = TRUE,
  verbose = TRUE,
  meta.info,
  BPPARAM = NULL,
  group.name,
  formula.str,
  robust = TRUE,
  trend = TRUE,
  permutating.group = FALSE
)
}
\arguments{
\item{x}{A \code{SummarizedExperiment} object, where rows
represent features (e.g., proteins, metabolites) and columns
represent samples.
The values should be log-transformed.}

\item{niter}{An integer representing the amount of bootstrap iterations.
Default is 1000.}

\item{K}{An optional integer representing the top list size for ranking.
If not specified, it is set to one-fourth of the number of features.}

\item{a1}{Optional numeric value used in the optimization process.
If defined by the user, no optimization occurs.}

\item{a2}{Optional numeric value used in the optimization process.
If defined by the user, no optimization occurs.}

\item{log}{Logical, indicating whether the data is already log-transformed.
Default is \code{TRUE}.}

\item{verbose}{Logical, indicating whether to display messages during the
function's execution. Default is \code{TRUE}.}

\item{meta.info}{a character vector of the metadata needed for the
model to run and can be retrieved using \code{colData()}.}

\item{BPPARAM}{A \code{BiocParallelParam} object specifying the
parallelization backend (e.g., \code{MulticoreParam}, \code{SnowParam}).
The default depends on the operating system: if the user is on Windows,
\code{SnowParam(workers = 2)} is used; otherwise,
\code{MulticoreParam(workers = 2)}.}

\item{group.name}{A string specifying the column in \code{meta.info} that
represents the groups or conditions for comparison. group.name should be
retrieved using \code{colData()} as factor.}

\item{formula.str}{A formula string for modeling.
It should include "~ 0 + ..." to exclude the intercept from the model.
All the model parameters must be present in \code{meta.info}.}

\item{robust}{indicating whether robust fitting should be used.
Default is TRUE, see \link[limma]{eBayes}.}

\item{trend}{indicating whether to include trend fitting in the
differential expression analysis. Default is TRUE. see \link[limma]{eBayes}.}

\item{permutating.group}{Logical, If \code{TRUE}, the permutation for
calculating the null distribution is performed by permuting the target group
only specified in \code{group.name} Preserving all the other sample
information. If \code{FALSE}, the entire sample information retrieved from
\code{meta.info} will be permuted (recommended to be set to FALSE).}
}
\value{
An object of class \code{"SummarizedExperiment"} with the
following elements:
\item{data}{The original data matrix.}
\item{niter}{The number of bootstrap samples used.}
\item{statistics}{The optimized statistics for each feature.}
\item{logfc}{Log-fold change values between groups.}
\item{pvalue}{P-values computed based on the permutation samples.}
\item{FDR}{False discovery rate estimates.}
\item{a1}{Optimized parameter used in differential expression ranking.}
\item{a2}{Optimized parameter used in differential expression ranking.}
\item{k}{Top list size used for ranking.}
\item{corrected.logfc}{estimate of the log2-fold-change
corresponding to the effect corrected by the s model
see \link[limma]{topTable}.}
\item{q_values}{Estimated q-values using the \code{qvalue} package.}
\item{BH.pvalue}{Benjamini-Hochberg adjusted p-values.}
\item{null.statistics}{The optimized null statistics for each feature.}
}
\description{
\code{LimROTS}: A Hybrid Method Integrating Empirical Bayes and
Reproducibility-Optimized Statistics for Robust
Differential Expression Analysis
}
\details{
The \strong{LimROTS} approach initially uses
\pkg{limma} package functionality to simulate the intensity data of
proteins and
metabolites. A linear model is subsequently fitted using the design matrix.
Empirical Bayes variance shrinking is then implemented. To obtain the
moderated t-statistics, the adjusted standard error
\eqn{SE_{post} = \sqrt{s^2_{\text{post}} } \times unscaled SD}
for each feature is computed, along with the regression
coefficient for each feature (indicating the impact of variations in the
experimental settings). Then, by adapting a reproducibility-optimized
technique known as \link[ROTS]{ROTS} to establish an optimality
based on the largest overlap of top-ranked features within group-preserving
bootstrap datasets, Finally based on the optimized parameters
\eqn{\alpha1} and
\eqn{\alpha2} this equation used to calculates the final statistics:

\deqn{t_{\alpha_{(p)}} = \frac{\beta_{(p)}}
         {\alpha1 + \alpha2 \times SEpost_{(p)}}}where
\eqn{t_{\alpha_{(p)}}} is the final statistics for each feature,
\eqn{\beta_{(p)}} is the coefficient, and \eqn{SEpost_{(p)}}
is the the adjusted
standard error. LimROTS generates p-values from permutation samples
using the implementation available in
\link[qvalue]{qvalue} package, along with internal implementation of FDR
adapted from ROTS package. Additionally, the qvalue package is used
to calculate q-values, were the proportion of true null p-values is
set to the bootstrap method \link[qvalue]{pi0est}. We recommend using
permutation-derived p-values and qvalues.

This function processes a dataset using parallel computation. It
leverages the \pkg{BiocParallel} framework to distribute tasks
across multiple workers, which  can significantly reduce runtime for
large datasets.
}
\examples{
# Example usage:

data <- data.frame(matrix(rnorm(500), nrow = 100, ncol = 10))
# Simulated data
meta.info <- data.frame(
    group = factor(rep(1:2, each = 5)),
    row.names = colnames(data)
)
formula.str <- "~ 0 + group"
result <- LimROTS(data,
    meta.info = meta.info, group.name = "group",
    formula.str = formula.str, niter = 10
)

}
\references{
Ritchie, M.E., Phipson, B., Wu, D., Hu, Y., Law, C.W., Shi, W., and Smyth,
G.K. (2015). limma powers differential expression analyses for
RNA-sequencing and microarray studies. Nucleic Acids Research 43(7), e47

Suomi T, Seyednasrollah F, Jaakkola M, Faux T, Elo L (2017). “ROTS: An
R package for reproducibility-optimized statistical testing.
” \emph{PLoS computational biology}, \emph{13}(5), e1005562.
\url{doi:10.1371/journal.pcbi.1005562}
\url{https://doi.org/10.1371/journal.pcbi.1005562},
\url{http://www.ncbi.nlm.nih.gov/pubmed/28542205}

Elo LL, Filen S, Lahesmaa R, Aittokallio T. Reproducibility-optimized test
statistic for ranking genes in microarray studies.
IEEE/ACM Trans Comput Biol Bioinform. 2008;5(3):423-431.
\url{doi:10.1109/tcbb.2007.1078}
}
