% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpretation.R
\name{qtlBaseSubstitutionEnrichment}
\alias{qtlBaseSubstitutionEnrichment}
\title{qtlBaseSubstitutionEnrichment}
\usage{
qtlBaseSubstitutionEnrichment(meth.qtl.res, merge = FALSE)
}
\arguments{
\item{meth.qtl.res}{An object of type \code{\link{MethQTLResult-class}} or a list of such objects.}

\item{merge}{Flag indicating if 5' and 3' substitutions are to be merged or to be analyzed separately.}
}
\value{
A list with one element for each potential base substitution containing the enrichment p-value.
}
\description{
This function tests for enrichment of a specific base substitution in the methQTL interactions.
}
\details{
The names of the list are e.g. \code{A_G}, which refers to a replacement of the reference base \code{A}
with an \code{A}. Enrichment is computed using Fisher's exact test, using all SNP that have been used
as input as the background.
}
\examples{
meth.qtl.res <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
res <- qtlBaseSubstitutionEnrichment(meth.qtl.res)
}
\author{
Michael Scherer
}
