% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{isUpdated}
\alias{isUpdated}
\alias{isUpdated<-}
\alias{isModified}
\alias{isModified<-}
\alias{isUpdated,MLSeq-method}
\alias{isUpdated<-,MLSeq,logical-method}
\alias{isModified,MLSeq-method}
\alias{isModified<-,MLSeq,logical-method}
\title{Checks if MLSeq object is updated/modified or not.}
\usage{
isUpdated(object)

isUpdated(object) <- value

isModified(object)

isModified(object) <- value

\S4method{isUpdated}{MLSeq}(object)

\S4method{isUpdated}{MLSeq,logical}(object) <- value

\S4method{isModified}{MLSeq}(object)

\S4method{isModified}{MLSeq,logical}(object) <- value
}
\arguments{
\item{object}{an \code{MLSeq} object.}

\item{value}{a logical. Change the state of update info.}
}
\value{
a logical.
}
\description{
These functions are used to check whether the \code{MLSeq} object is modified and/or updated. It is possible to update
classification parameters of \code{MLSeq} object which is returned by \code{classify()} function.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

isUpdated(cart)
isModified(cart)
}

}
