% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{trainParameters}
\alias{trainParameters}
\alias{trainParameters,MLSeq-method}
\alias{trainParameters,MLSeqModelInfo-method}
\title{Accessors for the 'trainParameters' slot.}
\usage{
trainParameters(object)

\S4method{trainParameters}{MLSeq}(object)

\S4method{trainParameters}{MLSeqModelInfo}(object)
}
\arguments{
\item{object}{an \code{MLSeq} or \code{MLSeqModelInfo} object.}
}
\description{
This slot stores the transformation and normalization parameters from train set. These parameters are used to normalize and
transform test set using train set parameters.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

trainParameters(cart)
}

}
