% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_ProteomeDiscoverer.R
\name{.cleanRawPD}
\alias{.cleanRawPD}
\title{Clean raw Proteome Discoverer data}
\usage{
.cleanRawPD(
  msstats_object,
  quantification_column,
  protein_id_column,
  sequence_column,
  remove_shared,
  remove_protein_groups = TRUE,
  intensity_columns_regexp = "Abundance"
)
}
\arguments{
\item{msstats_object}{an object of class \code{MSstatsSpectroMineFiles}.}

\item{quantification_column}{chr, name of a column used for quantification.}

\item{protein_id_column}{chr, name of a column with protein IDs.}

\item{sequence_column}{chr, name of a column with peptide sequences.}

\item{remove_shared}{lgl, if TRUE, shared peptides will be removed.}

\item{remove_protein_groups}{if TRUE, proteins with numProteins > 1 will be removed.}

\item{intensity_columns_regexp}{regular expressions that defines intensity columns.
Defaults to "Abundance", which means that columns that contain the word "Abundance"
will be treated as corresponding to intensities for different channels.}
}
\value{
data.table
}
\description{
Clean raw Proteome Discoverer data
}
