% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{maxq_lf_annotation}
\alias{maxq_lf_annotation}
\title{Example annotation file for a label-free MaxQuant experiment.}
\format{
A data.table with 5 columns.
}
\usage{
maxq_lf_annotation
}
\description{
Must be manually created by the user and input into the
MaxQtoMSstatsPTMFormat converter. Requires the correct columns and maps the
experimental desing into the MSstats format. Specify unique bioreplicates for
group comparison designs, and the same bioreplicate for repeated measure
designs. The columns and descriptions are below.
}
\details{
\itemize{
\item Run : Run name that matches exactly with MaxQuant run. Used to join
evidence and metadata in annotation file.
\item Condition : Name of condition that was used for each run.
\item BioReplicate : Name of biological replicate. Repeating the same name
here will tell MSstatsPTM that the experiment is a repeated measure design.
\item Raw.file : Run name that matches exactly with MaxQuant run. Used to join
evidence and metadata in annotation file.
\item IsotopeLabelType: Name of isotope label. May be all \code{L} or unique
depending on experimental design.
}
}
\examples{
head(maxq_lf_annotation)
}
\keyword{datasets}
