% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_dynamics.R
\name{cluster_dynamics}
\alias{cluster_dynamics}
\title{cluster dynamics profiles of metabolites}
\usage{
cluster_dynamics(
  data = NULL,
  fit,
  estimates = NULL,
  distance = "euclidean",
  agglomeration = "ward.D2",
  minClusterSize = 1,
  deepSplit = 2,
  B = 1000
)
}
\arguments{
\item{data}{data frame or colData of a \link[SummarizedExperiment]{SummarizedExperiment}
used to fit dynamics model}

\item{fit}{model fit obtained by fit_dynamics_model(). Needed if data is not a
SummarizedExperiment object for which the model fit is saved in "dynamic_fit" of metadata}

\item{estimates}{output of estimates_dynamics function, needed if data is not
a SummarizedExperiment object for which the model estimates are saved in "estimates_dynamics"
of metadata}

\item{distance}{distance method to be used as input for hierarchical clustering \link[stats]{dist}
can be "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski"}

\item{agglomeration}{agglomerative method to be used for hierarchical clustering \link[stats]{hclust}
can be "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid"}

\item{minClusterSize}{minimum number of metabolites per of cluster \link[dynamicTreeCut]{cutreeDynamic}}

\item{deepSplit}{rough control over sensitivity of cluster analysis. Possible values are 0:4,
the higher the value, the more and smaller clusters will be produced by \link[dynamicTreeCut]{cutreeDynamic}}

\item{B}{number of bootstraps}
}
\value{
a list with one list per condition. The elements per condition are
'data' (mean estimates of mu plus the clustering solution),
mean_dendro' the dendrogram of the mean estimates, and
mean_phylo' the phylogram of the mean estimates.
if data is a \link[SummarizedExperiment]{SummarizedExperiment} object clustering
results are stored in metadata under "cluster"
Element 'dynamics' contains column names of time points
}
\description{
Convenient wrapper function for clustering of metabolite dynamics
employing the "hybrid" method of the \link[dynamicTreeCut]{dynamicTreeCut}
package for clustering and \link[stats]{hclust} for computing of distance
matrix and hierarchical clustering needed as input for dynamicTreeCut.
Provides bootstrapping of clustering solution from posterior estimates of the model.
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition == "A" &
  longitudinalMetabolomics$metabolite \%in\% c("ATP", "L-Alanine", "GDP")]
data <- fit_dynamics_model(
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- estimates_dynamics(
  data = data
)
data <- cluster_dynamics(data, B = 1000)
S4Vectors::metadata(data)[["cluster"]][["A"]]
plot(S4Vectors::metadata(data)[["cluster"]][["A"]][["mean_dendro"]])
}
\seealso{
\code{\link[=fit_dynamics_model]{fit_dynamics_model()}}, \code{\link[=estimates_dynamics]{estimates_dynamics()}}, \code{\link[=plot_cluster]{plot_cluster()}}
}
